$(document).ready(function () {
  //particle js background
  let link = location.href.split("/");
  link = link[link.length - 1];
  console.log(link);
  if (link == "") {
    particlesJS.load("particles-js", "./assets/js/particlejs/particles.json");
  }

  new WOW().init({
    duration: 1000,
  });

  AOS.init({
    duration: 1200,
    once: false,
    mirror: true,
    disable: "mobile",
  });

  //typed js
  if (link == "") {
    var typed = new Typed(".hero-type", {
      strings: [
        "We are building a Marketplace with Access to Blockchain Technologies.",
      ],
      typeSpeed: 20,
      startDelay: 2000,
    });
  }

  //carousel
  $(".owl-carousel-1").owlCarousel({
    autoplayHoverPause: false,
    loop: true,
    autoplay: true,
    autoplayTimeout: 3000,
    slideTransition: "linear",
    autoplaySpeed: 3000,
    center: true,
    dots: false,
    responsive: {
      0: {
        items: 1,
        margin: 20,
      },
      600: {
        items: 2,
        margin: 30,
      },
      1000: {
        items: 3,
        margin: 50,
      },
    },
  });

  $(".owl-carousel-2").owlCarousel({
    autoplayHoverPause: false,
    loop: true,
    autoplay: true,
    autoplayTimeout: 5000,
    slideTransition: "linear",
    autoplaySpeed: 5000,
    center: true,
    dots: false,
    responsive: {
      0: {
        items: 1,
        margin: 20,
      },
      600: {
        items: 2,
        margin: 30,
      },
      1000: {
        items: 3,
        margin: 50,
      },
    },
  });

  $(".searchButton1").on("click", function () {
    console.log("copied text");
    var text = document.getElementById("copy-text");
    text.select();
    text.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(text.value);
  });

  //tilt js
  // console.log(window.innerWidth);
  // if (window.innerWidth > 900) {
  //     VanillaTilt.init(document.querySelectorAll(".single-token-box"), {
  //         max: 20,
  //         glare: true,
  //         speed: 500,
  //     });

  //     VanillaTilt.init(document.querySelectorAll(".single-service-box"), {
  //         max: 20,
  //         glare: true,
  //         speed: 400,
  //     });
  // }

  //chartjs
  // const data = {
  //     labels: ["Exchange", "CEX Wallet", "DEX Wallet"],
  //     datasets: [
  //         {
  //             label: "TYV Coin Distribution",
  //             data: [60, 15, 25],
  //             backgroundColor: ["rgb(255, 99, 132)", "rgb(54, 162, 235)", "rgb(255, 205, 86)"],
  //             hoverOffset: 4,
  //         },
  //     ],
  // };
  // const config = {
  //     type: "pie",
  //     data: data,
  //     options: {
  //         responsive: true,
  //         plugins: {
  //             legend: {
  //                 position: "none",
  //             },
  //         },
  //     },
  // };
  // const myChart = new Chart(document.getElementById("myChart"), config);

  //high chart
  // let innerSize = 100;
  // if (window.innerWidth < 600) {
  //     innerSize = 50;
  // }
  // Highcharts.chart("chart-container", {
  //     chart: {
  //         type: "pie",
  //         options3d: {
  //             enabled: true,
  //             alpha: 50,
  //         },
  //     },
  //     title: {
  //         text: "",
  //     },
  //     subtitle: {
  //         text: "",
  //     },
  //     plotOptions: {
  //         pie: {
  //             innerSize: innerSize,
  //             depth: 45,
  //         },
  //     },
  //     series: [
  //         {
  //             name: "Tokens",
  //             data: [
  //                 ["Exchange", 60],
  //                 ["CEX wallet", 15],
  //                 ["DEX Wallet", 25],
  //             ],
  //         },
  //     ],
  //     responsive: {
  //         rules: [
  //             {
  //                 condition: {
  //                     maxWidth: 600,
  //                 },
  //                 chartOptions: {
  //                     legend: {
  //                         enabled: false,
  //                     },
  //                 },
  //             },
  //         ],
  //     },
  // });

  if (link == "") {
    let slideIndex = 0;
    function showSlides() {
      let i;
      let slides = document.getElementsByClassName("fade-in-image");
      let slides1 = document.getElementsByClassName("service-content");
      slides1 = [...slides1];
      slides = [...slides];
      for (i = 0; i < slides.length; i++) {
        slides[i].classList.add("hidden-img");
        slides1[i].classList.remove("bold-text");
      }
      slideIndex++;
      if (slideIndex > slides.length) {
        slideIndex = 1;
      }
      slides[slideIndex - 1].classList.remove("hidden-img");
      slides1[slideIndex - 1].classList.add("bold-text");
      clear = setTimeout(showSlides, 2000);
    }
    showSlides();

    //Image Show on Hover function
    $(".service-content").mouseenter(function () {
      [1, 2, 3, 4].forEach((i) => {
        $(`.content-${i}`).addClass("hidden-img");
      });
      [1, 2, 3, 4].forEach((i) => $(`#content-${i}`).removeClass("bold-text"));
      const id = this.id;
      $(`.${id}`).removeClass("hidden-img");
      $(`#${id}`).addClass("bold-text");
      slideIndex = id.split("-").pop();
      // console.log(clear);
      clearTimeout(clear);
    });

    //image carousel
    $(".imageCarousel-wrapper").mouseleave(function () {
      clearTimeout(clear);
      // console.log("reset");
      clear2 = setTimeout(() => {
        // console.log("new carousel");
        showSlides();
      }, 1000);
    });

    $(".imageCarousel-wrapper").mouseenter(function () {
      clearTimeout(clear2);
      // console.log("reset new carousel command");
    });
  }

  // counter animation for smart contract
  let variable = true;
  let type_choose = true;
  let type_new = false;
  let type_new_2 = false;
  let type_token = true;
  let type_new_3 = false;
  let type_faqs = true;
  let type_blog = true;
  let type_new_4 = false;

  $(document).on("scroll", function () {
    // console.log($(".feature-section-2").visible(true, true));
    if ($(".feature-section-2").visible(true, true)) {
      if (variable) {
        variable = false;
        $(".change-value").one("click", function () {
          const start = this.innerHTML - this.innerHTML * 0.5;
          console.log(start);
          $(this)
            .prop("Counter", start)
            .animate(
              {
                Counter: $(this).text(),
              },
              {
                duration: 2500,
                easing: "swing",
                step: function (now) {
                  $(this).text(Math.ceil(now));
                },
              }
            );
        });
        $(".change-value").trigger("click");
      }
    }
    if ($("#why-choose").visible(true, true)) {
      if (type_choose) {
        console.log("typing choose");
        type_choose = false;
        let string = $("#why-choose").html().trim();
        string = string == "" ? "Why to choose us?" : string;
        var typed = new Typed("#why-choose", {
          strings: [string, "Why to choose us?"],
          typeSpeed: 70,
          startDelay: 300,
          onComplete: (self) => {
            type_new = true;
          },
          smartBackspace: false,
        });
      }
    }
    if (type_new) {
      if (!$("#why-choose").visible(true, true)) {
        type_choose = true;
        type_new = false;
      }
    }
    if ($("#token-distribution").visible(true, true)) {
      // console.log(type_token);
      if (type_token) {
        console.log(type_token);
        type_token = false;
        let string = $("#token-distribution").html().trim();
        string = string == "" ? "Token Distribution" : string;
        console.log(string);
        var typed = new Typed("#token-distribution", {
          strings: [string, "Token Distribution"],
          typeSpeed: 70,
          startDelay: 300,
          smartBackspace: false,
          onComplete: (self) => {
            type_new_2 = true;
          },
        });
      }
    }
    if (type_new_2) {
      if (!$("#token-distribution").visible(true, true)) {
        type_token = true;
        type_new_2 = false;
      }
    }
    if ($("#token-distribution").visible(true, true)) {
      // console.log(type_token);
      if (type_token) {
        console.log(type_token);
        type_token = false;
        let string = $("#token-distribution").html().trim();
        string = string == "" ? "Token Distribution" : string;
        console.log(string);
        var typed = new Typed("#token-distribution", {
          strings: [string, "Token Distribution"],
          typeSpeed: 70,
          startDelay: 300,
          smartBackspace: false,
          onComplete: (self) => {
            type_new_2 = true;
          },
        });
      }
    }
    if (type_new_2) {
      if (!$("#token-distribution").visible(true, true)) {
        type_token = true;
        type_new_2 = false;
      }
    }
    if ($("#faq-span").visible(true, true)) {
      if (type_faqs) {
        console.log(type_token);
        type_faqs = false;
        let string = $("#faq-span").html().trim();
        string = string == "" ? "Frequently Asked Questions" : string;
        console.log(string);
        var typed = new Typed("#faq-span", {
          strings: [string, "Frequently Asked Questions"],
          typeSpeed: 30,
          startDelay: 200,
          smartBackspace: false,
          onComplete: (self) => {
            type_new_3 = true;
          },
          backSpeed: 1,
        });
      }
    }
    if (type_new_3) {
      if (!$("#faq-span").visible(true, true)) {
        type_faqs = true;
        type_new_3 = false;
      }
    }
    if ($("#blog-span").visible(true, true)) {
      if (type_blog) {
        type_blog = false;
        let string = $("#blog-span").html().trim();
        string = string == "" ? "Let's meet our Blog" : string;
        console.log(string);
        var typed = new Typed("#blog-span", {
          strings: [string, "Let's meet our Blog"],
          typeSpeed: 30,
          startDelay: 200,
          smartBackspace: false,
          onComplete: (self) => {
            type_new_4 = true;
          },
          backSpeed: 1,
        });
      }
    }
    if (type_new_4) {
      if (!$("#blog-span").visible(true, true)) {
        type_blog = true;
        type_new_4 = false;
      }
    }
  });

  if (link == "") {
    const SCROLL_SPEED = 0.3;
    const NOISE_SPEED = 0.004;
    const NOISE_AMOUNT = 5;
    const CANVAS_WIDTH = 2800;

    const bubblesEl = document.querySelector(".bubbles-2");
    const bubbleSpecs = [
      { s: 0.6, x: 1134, y: 45 },
      { s: 0.6, x: 1620, y: 271 },
      { s: 0.6, x: 1761, y: 372 },
      { s: 0.6, x: 2499, y: 79 },
      { s: 0.6, x: 2704, y: 334 },
      { s: 0.6, x: 2271, y: 356 },
      { s: 0.6, x: 795, y: 226 },
      { s: 0.6, x: 276, y: 256 },
      { s: 0.6, x: 1210, y: 365 },
      { s: 0.6, x: 444, y: 193 },
      { s: 0.6, x: 2545, y: 387 },
      { s: 0.8, x: 1303, y: 193 },
      { s: 0.8, x: 907, y: 88 },
      { s: 0.8, x: 633, y: 320 },
      { s: 0.8, x: 323, y: 60 },
      { s: 0.8, x: 129, y: 357 },
      { s: 0.8, x: 1440, y: 342 },
      { s: 0.8, x: 1929, y: 293 },
      { s: 0.8, x: 2135, y: 198 },
      { s: 0.8, x: 2276, y: 82 },
      { s: 0.8, x: 2654, y: 182 },
      { s: 0.8, x: 2783, y: 60 },
      { x: 1519, y: 118 },
      { x: 1071, y: 233 },
      { x: 1773, y: 148 },
      { x: 2098, y: 385 },
      { x: 2423, y: 244 },
      { x: 901, y: 385 },
      { x: 624, y: 111 },
      { x: 75, y: 103 },
      { x: 413, y: 367 },
      { x: 2895, y: 271 },
      { x: 1990, y: 75 },
    ];

    class Bubbles {
      constructor(specs) {
        this.bubbles = [];
        specs.forEach((spec, index) => {
          this.bubbles.push(new Bubble(index, spec));
        });
        requestAnimationFrame(this.update.bind(this));
      }
      update() {
        this.bubbles.forEach((bubble) => bubble.update());
        this.raf = requestAnimationFrame(this.update.bind(this));
      }
    }

    class Bubble {
      constructor(index, { x, y, s = 1 }) {
        this.index = index;
        this.x = x;
        this.y = y;
        this.scale = s;

        this.noiseSeedX = Math.floor(Math.random() * 64000);
        this.noiseSeedY = Math.floor(Math.random() * 64000);

        this.el = document.createElement("div");
        this.el.className = `bubble-2 logo${this.index + 1}`;
        bubblesEl.appendChild(this.el);
      }

      update() {
        this.noiseSeedX += NOISE_SPEED;
        this.noiseSeedY += NOISE_SPEED;
        let randomX = noise.simplex2(this.noiseSeedX, 0);
        let randomY = noise.simplex2(this.noiseSeedY, 0);

        this.x -= SCROLL_SPEED;
        this.xWithNoise = this.x + randomX * NOISE_AMOUNT;
        this.yWithNoise = this.y + randomY * NOISE_AMOUNT;

        if (this.x < -200) {
          this.x = CANVAS_WIDTH;
        }

        this.el.style.transform = `translate(${this.xWithNoise}px, ${this.yWithNoise}px) scale(${this.scale})`;
      }
    }
    // For perlin noise
    noise.seed(Math.floor(Math.random() * 64000));
    const bubbles = new Bubbles(bubbleSpecs);

    for (let i = 1, j = 1; i <= 33; i++, j++) {
      if (j > 8) {
        j = 1;
      }
      $(`.logo${i}`).html(
        `<img src="assets/images/token-dis/bubble_post_${j}.webp">`
      );
    }
  }
  // $('.logo31').html('Date of issue <b>7 Ferbruary 2022</b>')
  // $('.logo12').html('Listing on the coinsbit<b>12 Ferbruary 2022</b>')
  // $('.logo14').html('Capitalization<b>15,000,000$</b>')
  // $('.logo28').html('Total number<b>15,000,000 TYV</b>')
  // $('.logo29').html('Circulating Offer<b>10,000,000 TYV</b>')
  // $('.logo24').html('Total number of transactions<b>15,123</b>')
  // $('.logo23').html('Symbol of Token<b>TYV</b>')
  // $('.logo33').html('Quantity on the exchange<b>10,000,000 TYV</b>')

  $(".footer").hover(function () {
    $("body #magicMouseCursor").toggleClass("white-cursor");
    $("body #magicPointer").toggleClass("white-cursor-2");
  });

  if (link == "about-us") {
    $(".letter").animate(
      {
        display: "block",
        top: 0,
      },
      800,
      "swing",
      function () {
        $(".anim-forwards > .word").animate(
          {
            "margin-right": "5px",
          },
          300
        );
      }
    );
    // let animate = true;
    // $(document).scroll(function () {
    //     console.log($(".word").visible(true, true), animate)
    //     if ($(".word").visible(true, true)) {
    //         if (animate) {
    //             animate = false;
    //             console.log(animate)
    //             $('.word').animate({
    //                 display: 'block',
    //                 top: 0
    //             }, 1000, function () {
    //                 console.log('here')
    //                 animate = true;
    //                 $('.anim-forwards > .word').animate({
    //                     'margin-right': '5px'
    //                 }, 300)
    //             })
    //         }
    //     }
    //     // else {
    //     //     $('.word').animate({ display: 'none', top: '100%' });
    //     //     $('.anim-forwards > .word').animate({
    //     //         'margin-right': '-20px'
    //     //     }, 300)
    //     // }
    // })
    gsap.registerPlugin(ScrollTrigger);
    gsap.to(".text p", {});
  }

  // -------------- Change ---------------------- //

  if (link == "about-us") {
    gsap.registerPlugin(ScrollTrigger);
    let images = gsap.utils.toArray(".img");

    images.forEach((img, i) => {
      //   gsap.timeline({ paused: true, scrollTrigger: { trigger: img, } }).fromTo(
      //     img,
      //     {
      //       x: 0,
      //       y: 0,
      //       scrub: true,
      //     },
      //     {
      //       x: -25,
      //       y: -25,
      //       ease: "none",
      //       scrub: true,
      //     },
      //   );

      gsap.from(img, {
        x: 25,
        y: 25,
        duration: 1,
        scrollTrigger: {
          trigger: img,
          start: "10% bottom",
          toggleActions: "play complete restart reset",
        },
      });
      // gsap.from(img, {
      //   x: 25,
      //   y: 50,
      //   ease: "none",
      //   scrollTrigger: {
      //     trigger: img,
      //     start: "top 90%",
      //     end: "top 70%",
      //     scrub: true,
      //     id: `img-${i}`,
      //   },
      // });
    });
  }
});

