/*
 Highcharts JS v10.2.1 (2022-08-29)

 3D features for Highcharts JS

 License: www.highcharts.com/license
*/
(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/highcharts-3d",["highcharts"],function(D){d(D);d.Highcharts=D;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function D(d,u,x,B){d.hasOwnProperty(u)||(d[u]=B.apply(null,x),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:u,module:d[u]}})))}d=d?d._modules:{};D(d,"Core/Math3D.js",
[d["Core/Globals.js"],d["Core/Utilities.js"]],function(d,u){function x(f,c,k,n){var b=c.options.chart.options3d,m=v(n,k?c.inverted:!1),e={x:c.plotWidth/2,y:c.plotHeight/2,z:b.depth/2,vd:v(b.depth,1)*v(b.viewDistance,0)},z=c.scale3d||1;n=y*b.beta*(m?-1:1);b=y*b.alpha*(m?-1:1);var a=Math.cos(b),l=Math.cos(-n),t=Math.sin(b),p=Math.sin(-n);k||(e.x+=c.plotLeft,e.y+=c.plotTop);return f.map(function(b){var c=(m?b.y:b.x)-e.x;var k=(m?b.x:b.y)-e.y;b=(b.z||0)-e.z;c={x:l*c-p*b,y:-t*p*c+a*k-l*t*b,z:a*p*c+t*k+
a*l*b};k=A(c,e,e.vd);k.x=k.x*z+e.x;k.y=k.y*z+e.y;k.z=c.z*z+e.z;return{x:m?k.y:k.x,y:m?k.x:k.y,z:k.z}})}function A(f,c,k){c=0<k&&k<Number.POSITIVE_INFINITY?k/(f.z+c.z+k):1;return{x:f.x*c,y:f.y*c}}function f(f){var c=0,k;for(k=0;k<f.length;k++){var n=(k+1)%f.length;c+=f[k].x*f[n].y-f[n].x*f[k].y}return c/2}var y=d.deg2rad,v=u.pick;return{perspective:x,perspective3D:A,pointCameraDistance:function(f,c){var k=c.options.chart.options3d,n=c.plotWidth/2;c=c.plotHeight/2;k=v(k.depth,1)*v(k.viewDistance,0)+
k.depth;return Math.sqrt(Math.pow(n-v(f.plotX,f.x),2)+Math.pow(c-v(f.plotY,f.y),2)+Math.pow(k-v(f.plotZ,f.z),2))},shapeArea:f,shapeArea3D:function(d,c,k){return f(x(d,c,k))}}});D(d,"Core/Renderer/SVG/SVGElement3D.js",[d["Core/Color/Color.js"],d["Core/Renderer/SVG/SVGElement.js"],d["Core/Utilities.js"]],function(d,u,x){var A=d.parse,f=x.defined;d=x.merge;var y=x.objectEach,v=x.pick,E={base:{initArgs:function(c){var f=this,n=f.renderer,b=n[f.pathType+"Path"](c),d=b.zIndexes;f.parts.forEach(function(e){var c=
{"class":"highcharts-3d-"+e,zIndex:d[e]||0};n.styledMode&&("top"===e?c.filter="url(#highcharts-brighter)":"side"===e&&(c.filter="url(#highcharts-darker)"));f[e]=n.path(b[e]).attr(c).add(f)});f.attr({"stroke-linejoin":"round",zIndex:d.group});f.originalDestroy=f.destroy;f.destroy=f.destroyParts;f.forcedSides=b.forcedSides},singleSetterForParts:function(f,k,n,b,d,e){var c={};b=[null,null,b||"attr",d,e];var a=n&&n.zIndexes;n?(a&&a.group&&this.attr({zIndex:a.group}),y(n,function(b,e){c[e]={};c[e][f]=
b;a&&(c[e].zIndex=n.zIndexes[e]||0)}),b[1]=c):(c[f]=k,b[0]=c);return this.processParts.apply(this,b)},processParts:function(f,k,d,b,m){var e=this;e.parts.forEach(function(c){k&&(f=v(k[c],!1));if(!1!==f)e[c][d](f,b,m)});return e},destroyParts:function(){this.processParts(null,null,"destroy");return this.originalDestroy()}}};E.cuboid=d(E.base,{parts:["front","top","side"],pathType:"cuboid",attr:function(c,k,d,b){if("string"===typeof c&&"undefined"!==typeof k){var n=c;c={};c[n]=k}return c.shapeArgs||
f(c.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](c.shapeArgs||c)):u.prototype.attr.call(this,c,void 0,d,b)},animate:function(c,k,d){if(f(c.x)&&f(c.y)){c=this.renderer[this.pathType+"Path"](c);var b=c.forcedSides;this.singleSetterForParts("d",null,c,"animate",k,d);this.attr({zIndex:c.zIndexes.group});b!==this.forcedSides&&(this.forcedSides=b,this.renderer.styledMode||E.cuboid.fillSetter.call(this,this.fill))}else u.prototype.animate.call(this,c,k,d);return this},fillSetter:function(f){this.forcedSides=
this.forcedSides||[];this.singleSetterForParts("fill",null,{front:f,top:A(f).brighten(0<=this.forcedSides.indexOf("top")?0:.1).get(),side:A(f).brighten(0<=this.forcedSides.indexOf("side")?0:-.1).get()});this.color=this.fill=f;return this}});return E});D(d,"Core/Renderer/SVG/SVGRenderer3D.js",[d["Core/Animation/AnimationUtilities.js"],d["Core/Color/Color.js"],d["Core/Globals.js"],d["Core/Math3D.js"],d["Core/Renderer/SVG/SVGElement.js"],d["Core/Renderer/SVG/SVGElement3D.js"],d["Core/Renderer/SVG/SVGRenderer.js"],
d["Core/Utilities.js"]],function(d,u,x,B,f,y,v,E){var c=this&&this.__extends||function(){var a=function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,h){a.__proto__=h}||function(a,h){for(var r in h)h.hasOwnProperty(r)&&(a[r]=h[r])};return a(b,f)};return function(b,f){function e(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(e.prototype=f.prototype,new e)}}(),k=d.animObject,n=u.parse,b=x.charts,m=x.deg2rad,e=B.perspective,z=B.shapeArea,a=E.defined,l=E.extend,
t=E.merge,p=E.pick,G=Math.cos,H=Math.sin,I=Math.PI,F=4*(Math.sqrt(2)-1)/3/(I/2);return function(d){function w(){return null!==d&&d.apply(this,arguments)||this}c(w,d);w.compose=function(a){a=a.prototype;var b=w.prototype;a.elements3d=y;a.arc3d=b.arc3d;a.arc3dPath=b.arc3dPath;a.cuboid=b.cuboid;a.cuboidPath=b.cuboidPath;a.element3d=b.element3d;a.face3d=b.face3d;a.polyhedron=b.polyhedron;a.toLinePath=b.toLinePath;a.toLineSegments=b.toLineSegments};w.curveTo=function(a,b,h,r,g,q,C,f){var e=[],l=q-g;return q>
g&&q-g>Math.PI/2+.0001?(e=e.concat(this.curveTo(a,b,h,r,g,g+Math.PI/2,C,f)),e=e.concat(this.curveTo(a,b,h,r,g+Math.PI/2,q,C,f))):q<g&&g-q>Math.PI/2+.0001?(e=e.concat(this.curveTo(a,b,h,r,g,g-Math.PI/2,C,f)),e=e.concat(this.curveTo(a,b,h,r,g-Math.PI/2,q,C,f))):[["C",a+h*Math.cos(g)-h*F*l*Math.sin(g)+C,b+r*Math.sin(g)+r*F*l*Math.cos(g)+f,a+h*Math.cos(q)+h*F*l*Math.sin(q)+C,b+r*Math.sin(q)-r*F*l*Math.cos(q)+f,a+h*Math.cos(q)+C,b+r*Math.sin(q)+f]]};w.prototype.toLinePath=function(a,b){var h=[];a.forEach(function(a){h.push(["L",
a.x,a.y])});a.length&&(h[0][0]="M",b&&h.push(["Z"]));return h};w.prototype.toLineSegments=function(a){var b=[],h=!0;a.forEach(function(a){b.push(h?["M",a.x,a.y]:["L",a.x,a.y]);h=!h});return b};w.prototype.face3d=function(l){var c=this,h=this.createElement("path");h.vertexes=[];h.insidePlotArea=!1;h.enabled=!0;h.attr=function(h){if("object"===typeof h&&(a(h.enabled)||a(h.vertexes)||a(h.insidePlotArea))){this.enabled=p(h.enabled,this.enabled);this.vertexes=p(h.vertexes,this.vertexes);this.insidePlotArea=
p(h.insidePlotArea,this.insidePlotArea);delete h.enabled;delete h.vertexes;delete h.insidePlotArea;var g=e(this.vertexes,b[c.chartIndex],this.insidePlotArea),q=c.toLinePath(g,!0);g=z(g);h.d=q;h.visibility=this.enabled&&0<g?"inherit":"hidden"}return f.prototype.attr.apply(this,arguments)};h.animate=function(h){if("object"===typeof h&&(a(h.enabled)||a(h.vertexes)||a(h.insidePlotArea))){this.enabled=p(h.enabled,this.enabled);this.vertexes=p(h.vertexes,this.vertexes);this.insidePlotArea=p(h.insidePlotArea,
this.insidePlotArea);delete h.enabled;delete h.vertexes;delete h.insidePlotArea;var g=e(this.vertexes,b[c.chartIndex],this.insidePlotArea),q=c.toLinePath(g,!0);g=z(g);g=this.enabled&&0<g?"visible":"hidden";h.d=q;this.attr("visibility",g)}return f.prototype.animate.apply(this,arguments)};return h.attr(l)};w.prototype.polyhedron=function(b){var e=this,h=this.g(),r=h.destroy;this.styledMode||h.attr({"stroke-linejoin":"round"});h.faces=[];h.destroy=function(){for(var g=0;g<h.faces.length;g++)h.faces[g].destroy();
return r.call(this)};h.attr=function(g,q,b,r){if("object"===typeof g&&a(g.faces)){for(;h.faces.length>g.faces.length;)h.faces.pop().destroy();for(;h.faces.length<g.faces.length;)h.faces.push(e.face3d().add(h));for(var C=0;C<g.faces.length;C++)e.styledMode&&delete g.faces[C].fill,h.faces[C].attr(g.faces[C],null,b,r);delete g.faces}return f.prototype.attr.apply(this,arguments)};h.animate=function(g,a,b){if(g&&g.faces){for(;h.faces.length>g.faces.length;)h.faces.pop().destroy();for(;h.faces.length<g.faces.length;)h.faces.push(e.face3d().add(h));
for(var q=0;q<g.faces.length;q++)h.faces[q].animate(g.faces[q],a,b);delete g.faces}return f.prototype.animate.apply(this,arguments)};return h.attr(b)};w.prototype.element3d=function(a,b){var h=this.g();l(h,this.elements3d[a]);h.initArgs(b);return h};w.prototype.cuboid=function(a){return this.element3d("cuboid",a)};w.prototype.cuboidPath=function(a){function f(a){return 0===C&&1<a&&6>a?{x:t[a].x,y:t[a].y+10,z:t[a].z}:t[0].x===t[7].x&&4<=a?{x:t[a].x+10,y:t[a].y,z:t[a].z}:0===c&&2>a||5<a?{x:t[a].x,y:t[a].y,
z:t[a].z+10}:t[a]}function h(a){return t[a]}var r=a.x||0,g=a.y||0,q=a.z||0,C=a.height||0,l=a.width||0,c=a.depth||0,p=b[this.chartIndex],d=p.options.chart.options3d.alpha,k=0,t=[{x:r,y:g,z:q},{x:r+l,y:g,z:q},{x:r+l,y:g+C,z:q},{x:r,y:g+C,z:q},{x:r,y:g+C,z:q+c},{x:r+l,y:g+C,z:q+c},{x:r+l,y:g,z:q+c},{x:r,y:g,z:q+c}],w=[];t=e(t,p,a.insidePlotArea);var n=function(a,g,q){var b=[[],-1],r=a.map(h),C=g.map(h);a=a.map(f);g=g.map(f);0>z(r)?b=[r,0]:0>z(C)?b=[C,1]:q&&(w.push(q),b=0>z(a)?[r,0]:0>z(g)?[C,1]:[r,0]);
return b};var m=n([3,2,1,0],[7,6,5,4],"front");a=m[0];var H=m[1];m=n([1,6,7,0],[4,5,2,3],"top");l=m[0];var G=m[1];m=n([1,2,5,6],[0,7,4,3],"side");n=m[0];m=m[1];1===m?k+=1E6*(p.plotWidth-r):m||(k+=1E6*r);k+=10*(!G||0<=d&&180>=d||360>d&&357.5<d?p.plotHeight-g:10+g);1===H?k+=100*q:H||(k+=100*(1E3-q));return{front:this.toLinePath(a,!0),top:this.toLinePath(l,!0),side:this.toLinePath(n,!0),zIndexes:{group:Math.round(k)},forcedSides:w,isFront:H,isTop:G}};w.prototype.arc3d=function(a){function b(a){var h=
!1,b={},q;a=t(a);for(q in a)-1!==g.indexOf(q)&&(b[q]=a[q],delete a[q],h=!0);return h?[b,a]:!1}var h=this.g(),r=h.renderer,g="x y r innerR start end depth".split(" ");a=t(a);a.alpha=(a.alpha||0)*m;a.beta=(a.beta||0)*m;h.top=r.path();h.side1=r.path();h.side2=r.path();h.inn=r.path();h.out=r.path();h.onAdd=function(){var a=h.parentGroup,g=h.attr("class");h.top.add(h);["out","inn","side1","side2"].forEach(function(b){h[b].attr({"class":g+" highcharts-3d-side"}).add(a)})};["addClass","removeClass"].forEach(function(a){h[a]=
function(){var g=arguments;["top","out","inn","side1","side2"].forEach(function(b){h[b][a].apply(h[b],g)})}});h.setPaths=function(a){var g=h.renderer.arc3dPath(a),b=100*g.zTop;h.attribs=a;h.top.attr({d:g.top,zIndex:g.zTop});h.inn.attr({d:g.inn,zIndex:g.zInn});h.out.attr({d:g.out,zIndex:g.zOut});h.side1.attr({d:g.side1,zIndex:g.zSide1});h.side2.attr({d:g.side2,zIndex:g.zSide2});h.zIndex=b;h.attr({zIndex:b});a.center&&(h.top.setRadialReference(a.center),delete a.center)};h.setPaths(a);h.fillSetter=
function(a){var g=n(a).brighten(-.1).get();this.fill=a;this.side1.attr({fill:g});this.side2.attr({fill:g});this.inn.attr({fill:g});this.out.attr({fill:g});this.top.attr({fill:a});return this};["opacity","translateX","translateY","visibility"].forEach(function(a){h[a+"Setter"]=function(a,g){h[g]=a;["out","inn","side1","side2","top"].forEach(function(b){h[b].attr(g,a)})}});h.attr=function(a){var g;if("object"===typeof a&&(g=b(a))){var q=g[0];arguments[0]=g[1];l(h.attribs,q);h.setPaths(h.attribs)}return f.prototype.attr.apply(h,
arguments)};h.animate=function(a,g,r){var q=this.attribs,e="data-"+Math.random().toString(26).substring(2,9);delete a.center;delete a.z;delete a.alpha;delete a.beta;var l=k(p(g,this.renderer.globalAnimation));if(l.duration){g=b(a);h[e]=0;a[e]=1;h[e+"Setter"]=x.noop;if(g){var c=g[0];l.step=function(a,g){function h(a){return q[a]+(p(c[a],q[a])-q[a])*g.pos}g.prop===e&&g.elem.setPaths(t(q,{x:h("x"),y:h("y"),r:h("r"),innerR:h("innerR"),start:h("start"),end:h("end"),depth:h("depth")}))}}g=l}return f.prototype.animate.call(this,
a,g,r)};h.destroy=function(){this.top.destroy();this.out.destroy();this.inn.destroy();this.side1.destroy();this.side2.destroy();return f.prototype.destroy.call(this)};h.hide=function(){this.top.hide();this.out.hide();this.inn.hide();this.side1.hide();this.side2.hide()};h.show=function(a){this.top.show(a);this.out.show(a);this.inn.show(a);this.side1.show(a);this.side2.show(a)};return h};w.prototype.arc3dPath=function(a){function b(a){a%=2*Math.PI;a>Math.PI&&(a=2*Math.PI-a);return a}var h=a.x||0,r=
a.y||0,g=a.start||0,q=(a.end||0)-.00001,f=a.r||0,e=a.innerR||0,l=a.depth||0,c=a.alpha||0,p=a.beta||0,t=Math.cos(g),d=Math.sin(g);a=Math.cos(q);var k=Math.sin(q),n=f*Math.cos(p);f*=Math.cos(c);var m=e*Math.cos(p),z=e*Math.cos(c);e=l*Math.sin(p);var v=l*Math.sin(c);l=[["M",h+n*t,r+f*d]];l=l.concat(w.curveTo(h,r,n,f,g,q,0,0));l.push(["L",h+m*a,r+z*k]);l=l.concat(w.curveTo(h,r,m,z,q,g,0,0));l.push(["Z"]);var F=0<p?Math.PI/2:0;p=0<c?0:Math.PI/2;F=g>-F?g:q>-F?-F:g;var y=q<I-p?q:g<I-p?I-p:q,u=2*I-p;c=[["M",
h+n*G(F),r+f*H(F)]];c=c.concat(w.curveTo(h,r,n,f,F,y,0,0));q>u&&g<u?(c.push(["L",h+n*G(y)+e,r+f*H(y)+v]),c=c.concat(w.curveTo(h,r,n,f,y,u,e,v)),c.push(["L",h+n*G(u),r+f*H(u)]),c=c.concat(w.curveTo(h,r,n,f,u,q,0,0)),c.push(["L",h+n*G(q)+e,r+f*H(q)+v]),c=c.concat(w.curveTo(h,r,n,f,q,u,e,v)),c.push(["L",h+n*G(u),r+f*H(u)]),c=c.concat(w.curveTo(h,r,n,f,u,y,0,0))):q>I-p&&g<I-p&&(c.push(["L",h+n*Math.cos(y)+e,r+f*Math.sin(y)+v]),c=c.concat(w.curveTo(h,r,n,f,y,q,e,v)),c.push(["L",h+n*Math.cos(q),r+f*Math.sin(q)]),
c=c.concat(w.curveTo(h,r,n,f,q,y,0,0)));c.push(["L",h+n*Math.cos(y)+e,r+f*Math.sin(y)+v]);c=c.concat(w.curveTo(h,r,n,f,y,F,e,v));c.push(["Z"]);p=[["M",h+m*t,r+z*d]];p=p.concat(w.curveTo(h,r,m,z,g,q,0,0));p.push(["L",h+m*Math.cos(q)+e,r+z*Math.sin(q)+v]);p=p.concat(w.curveTo(h,r,m,z,q,g,e,v));p.push(["Z"]);t=[["M",h+n*t,r+f*d],["L",h+n*t+e,r+f*d+v],["L",h+m*t+e,r+z*d+v],["L",h+m*t,r+z*d],["Z"]];h=[["M",h+n*a,r+f*k],["L",h+n*a+e,r+f*k+v],["L",h+m*a+e,r+z*k+v],["L",h+m*a,r+z*k],["Z"]];k=Math.atan2(v,
-e);r=Math.abs(q+k);a=Math.abs(g+k);g=Math.abs((g+q)/2+k);r=b(r);a=b(a);g=b(g);g*=1E5;q=1E5*a;r*=1E5;return{top:l,zTop:1E5*Math.PI+1,out:c,zOut:Math.max(g,q,r),inn:p,zInn:Math.max(g,q,r),side1:t,zSide1:.99*r,side2:h,zSide2:.99*q}};return w}(v)});D(d,"Core/Chart/Chart3D.js",[d["Core/Color/Color.js"],d["Core/Math3D.js"],d["Core/DefaultOptions.js"],d["Core/Utilities.js"]],function(d,u,x,B){var f=d.parse,y=u.perspective,v=u.shapeArea3D,A=x.defaultOptions,c=B.addEvent,k=B.isArray,n=B.merge,b=B.pick,m=
B.wrap,e;(function(e){function a(a){this.is3d()&&"scatter"===a.options.type&&(a.options.type="scatter3d")}function l(){if(this.chart3d&&this.is3d()){var a=this.renderer,b=this.options.chart.options3d,g=this.chart3d.get3dFrame(),q=this.plotLeft,e=this.plotLeft+this.plotWidth,c=this.plotTop,l=this.plotTop+this.plotHeight;b=b.depth;var p=q-(g.left.visible?g.left.size:0),d=e+(g.right.visible?g.right.size:0),t=c-(g.top.visible?g.top.size:0),n=l+(g.bottom.visible?g.bottom.size:0),k=0-(g.front.visible?g.front.size:
0),m=b+(g.back.visible?g.back.size:0),w=this.hasRendered?"animate":"attr";this.chart3d.frame3d=g;this.frameShapes||(this.frameShapes={bottom:a.polyhedron().add(),top:a.polyhedron().add(),left:a.polyhedron().add(),right:a.polyhedron().add(),back:a.polyhedron().add(),front:a.polyhedron().add()});this.frameShapes.bottom[w]({"class":"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:g.bottom.frontFacing?-1E3:1E3,faces:[{fill:f(g.bottom.color).brighten(.1).get(),vertexes:[{x:p,y:n,z:k},{x:d,y:n,z:k},
{x:d,y:n,z:m},{x:p,y:n,z:m}],enabled:g.bottom.visible},{fill:f(g.bottom.color).brighten(.1).get(),vertexes:[{x:q,y:l,z:b},{x:e,y:l,z:b},{x:e,y:l,z:0},{x:q,y:l,z:0}],enabled:g.bottom.visible},{fill:f(g.bottom.color).brighten(-.1).get(),vertexes:[{x:p,y:n,z:k},{x:p,y:n,z:m},{x:q,y:l,z:b},{x:q,y:l,z:0}],enabled:g.bottom.visible&&!g.left.visible},{fill:f(g.bottom.color).brighten(-.1).get(),vertexes:[{x:d,y:n,z:m},{x:d,y:n,z:k},{x:e,y:l,z:0},{x:e,y:l,z:b}],enabled:g.bottom.visible&&!g.right.visible},{fill:f(g.bottom.color).get(),
vertexes:[{x:d,y:n,z:k},{x:p,y:n,z:k},{x:q,y:l,z:0},{x:e,y:l,z:0}],enabled:g.bottom.visible&&!g.front.visible},{fill:f(g.bottom.color).get(),vertexes:[{x:p,y:n,z:m},{x:d,y:n,z:m},{x:e,y:l,z:b},{x:q,y:l,z:b}],enabled:g.bottom.visible&&!g.back.visible}]});this.frameShapes.top[w]({"class":"highcharts-3d-frame highcharts-3d-frame-top",zIndex:g.top.frontFacing?-1E3:1E3,faces:[{fill:f(g.top.color).brighten(.1).get(),vertexes:[{x:p,y:t,z:m},{x:d,y:t,z:m},{x:d,y:t,z:k},{x:p,y:t,z:k}],enabled:g.top.visible},
{fill:f(g.top.color).brighten(.1).get(),vertexes:[{x:q,y:c,z:0},{x:e,y:c,z:0},{x:e,y:c,z:b},{x:q,y:c,z:b}],enabled:g.top.visible},{fill:f(g.top.color).brighten(-.1).get(),vertexes:[{x:p,y:t,z:m},{x:p,y:t,z:k},{x:q,y:c,z:0},{x:q,y:c,z:b}],enabled:g.top.visible&&!g.left.visible},{fill:f(g.top.color).brighten(-.1).get(),vertexes:[{x:d,y:t,z:k},{x:d,y:t,z:m},{x:e,y:c,z:b},{x:e,y:c,z:0}],enabled:g.top.visible&&!g.right.visible},{fill:f(g.top.color).get(),vertexes:[{x:p,y:t,z:k},{x:d,y:t,z:k},{x:e,y:c,
z:0},{x:q,y:c,z:0}],enabled:g.top.visible&&!g.front.visible},{fill:f(g.top.color).get(),vertexes:[{x:d,y:t,z:m},{x:p,y:t,z:m},{x:q,y:c,z:b},{x:e,y:c,z:b}],enabled:g.top.visible&&!g.back.visible}]});this.frameShapes.left[w]({"class":"highcharts-3d-frame highcharts-3d-frame-left",zIndex:g.left.frontFacing?-1E3:1E3,faces:[{fill:f(g.left.color).brighten(.1).get(),vertexes:[{x:p,y:n,z:k},{x:q,y:l,z:0},{x:q,y:l,z:b},{x:p,y:n,z:m}],enabled:g.left.visible&&!g.bottom.visible},{fill:f(g.left.color).brighten(.1).get(),
vertexes:[{x:p,y:t,z:m},{x:q,y:c,z:b},{x:q,y:c,z:0},{x:p,y:t,z:k}],enabled:g.left.visible&&!g.top.visible},{fill:f(g.left.color).brighten(-.1).get(),vertexes:[{x:p,y:n,z:m},{x:p,y:t,z:m},{x:p,y:t,z:k},{x:p,y:n,z:k}],enabled:g.left.visible},{fill:f(g.left.color).brighten(-.1).get(),vertexes:[{x:q,y:c,z:b},{x:q,y:l,z:b},{x:q,y:l,z:0},{x:q,y:c,z:0}],enabled:g.left.visible},{fill:f(g.left.color).get(),vertexes:[{x:p,y:n,z:k},{x:p,y:t,z:k},{x:q,y:c,z:0},{x:q,y:l,z:0}],enabled:g.left.visible&&!g.front.visible},
{fill:f(g.left.color).get(),vertexes:[{x:p,y:t,z:m},{x:p,y:n,z:m},{x:q,y:l,z:b},{x:q,y:c,z:b}],enabled:g.left.visible&&!g.back.visible}]});this.frameShapes.right[w]({"class":"highcharts-3d-frame highcharts-3d-frame-right",zIndex:g.right.frontFacing?-1E3:1E3,faces:[{fill:f(g.right.color).brighten(.1).get(),vertexes:[{x:d,y:n,z:m},{x:e,y:l,z:b},{x:e,y:l,z:0},{x:d,y:n,z:k}],enabled:g.right.visible&&!g.bottom.visible},{fill:f(g.right.color).brighten(.1).get(),vertexes:[{x:d,y:t,z:k},{x:e,y:c,z:0},{x:e,
y:c,z:b},{x:d,y:t,z:m}],enabled:g.right.visible&&!g.top.visible},{fill:f(g.right.color).brighten(-.1).get(),vertexes:[{x:e,y:c,z:0},{x:e,y:l,z:0},{x:e,y:l,z:b},{x:e,y:c,z:b}],enabled:g.right.visible},{fill:f(g.right.color).brighten(-.1).get(),vertexes:[{x:d,y:n,z:k},{x:d,y:t,z:k},{x:d,y:t,z:m},{x:d,y:n,z:m}],enabled:g.right.visible},{fill:f(g.right.color).get(),vertexes:[{x:d,y:t,z:k},{x:d,y:n,z:k},{x:e,y:l,z:0},{x:e,y:c,z:0}],enabled:g.right.visible&&!g.front.visible},{fill:f(g.right.color).get(),
vertexes:[{x:d,y:n,z:m},{x:d,y:t,z:m},{x:e,y:c,z:b},{x:e,y:l,z:b}],enabled:g.right.visible&&!g.back.visible}]});this.frameShapes.back[w]({"class":"highcharts-3d-frame highcharts-3d-frame-back",zIndex:g.back.frontFacing?-1E3:1E3,faces:[{fill:f(g.back.color).brighten(.1).get(),vertexes:[{x:d,y:n,z:m},{x:p,y:n,z:m},{x:q,y:l,z:b},{x:e,y:l,z:b}],enabled:g.back.visible&&!g.bottom.visible},{fill:f(g.back.color).brighten(.1).get(),vertexes:[{x:p,y:t,z:m},{x:d,y:t,z:m},{x:e,y:c,z:b},{x:q,y:c,z:b}],enabled:g.back.visible&&
!g.top.visible},{fill:f(g.back.color).brighten(-.1).get(),vertexes:[{x:p,y:n,z:m},{x:p,y:t,z:m},{x:q,y:c,z:b},{x:q,y:l,z:b}],enabled:g.back.visible&&!g.left.visible},{fill:f(g.back.color).brighten(-.1).get(),vertexes:[{x:d,y:t,z:m},{x:d,y:n,z:m},{x:e,y:l,z:b},{x:e,y:c,z:b}],enabled:g.back.visible&&!g.right.visible},{fill:f(g.back.color).get(),vertexes:[{x:q,y:c,z:b},{x:e,y:c,z:b},{x:e,y:l,z:b},{x:q,y:l,z:b}],enabled:g.back.visible},{fill:f(g.back.color).get(),vertexes:[{x:p,y:n,z:m},{x:d,y:n,z:m},
{x:d,y:t,z:m},{x:p,y:t,z:m}],enabled:g.back.visible}]});this.frameShapes.front[w]({"class":"highcharts-3d-frame highcharts-3d-frame-front",zIndex:g.front.frontFacing?-1E3:1E3,faces:[{fill:f(g.front.color).brighten(.1).get(),vertexes:[{x:p,y:n,z:k},{x:d,y:n,z:k},{x:e,y:l,z:0},{x:q,y:l,z:0}],enabled:g.front.visible&&!g.bottom.visible},{fill:f(g.front.color).brighten(.1).get(),vertexes:[{x:d,y:t,z:k},{x:p,y:t,z:k},{x:q,y:c,z:0},{x:e,y:c,z:0}],enabled:g.front.visible&&!g.top.visible},{fill:f(g.front.color).brighten(-.1).get(),
vertexes:[{x:p,y:t,z:k},{x:p,y:n,z:k},{x:q,y:l,z:0},{x:q,y:c,z:0}],enabled:g.front.visible&&!g.left.visible},{fill:f(g.front.color).brighten(-.1).get(),vertexes:[{x:d,y:n,z:k},{x:d,y:t,z:k},{x:e,y:c,z:0},{x:e,y:l,z:0}],enabled:g.front.visible&&!g.right.visible},{fill:f(g.front.color).get(),vertexes:[{x:e,y:c,z:0},{x:q,y:c,z:0},{x:q,y:l,z:0},{x:e,y:l,z:0}],enabled:g.front.visible},{fill:f(g.front.color).get(),vertexes:[{x:d,y:n,z:k},{x:p,y:n,z:k},{x:p,y:t,z:k},{x:d,y:t,z:k}],enabled:g.front.visible}]})}}
function t(){this.styledMode&&[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(a){this.renderer.definition({tagName:"filter",attributes:{id:"highcharts-"+a.name},children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",attributes:{type:"linear",slope:a.slope}},{tagName:"feFuncG",attributes:{type:"linear",slope:a.slope}},{tagName:"feFuncB",attributes:{type:"linear",slope:a.slope}}]}]})},this)}function p(){var a=this.options;this.is3d()&&(a.series||[]).forEach(function(b){"scatter"===
(b.type||a.chart.type||a.chart.defaultSeriesType)&&(b.type="scatter3d")})}function d(){var a=this.options.chart.options3d;if(this.chart3d&&this.is3d()){a&&(a.alpha=a.alpha%360+(0<=a.alpha?0:360),a.beta=a.beta%360+(0<=a.beta?0:360));var b=this.inverted,g=this.clipBox,e=this.margin;g[b?"y":"x"]=-(e[3]||0);g[b?"x":"y"]=-(e[0]||0);g[b?"height":"width"]=this.chartWidth+(e[3]||0)+(e[1]||0);g[b?"width":"height"]=this.chartHeight+(e[0]||0)+(e[2]||0);this.scale3d=1;!0===a.fitToPlot&&(this.scale3d=this.chart3d.getScale(a.depth));
this.chart3d.frame3d=this.chart3d.get3dFrame()}}function z(){this.is3d()&&(this.isDirtyBox=!0)}function u(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function F(){this.chart3d||(this.chart3d=new B(this))}function w(a){return this.is3d()||a.apply(this,[].slice.call(arguments,1))}function x(a){var b=this.series.length;if(this.is3d())for(;b--;)a=this.series[b],a.translate(),a.render();else a.call(this)}function E(a){a.apply(this,[].slice.call(arguments,1));this.is3d()&&
(this.container.className+=" highcharts-3d-chart")}var B=function(){function a(a){this.frame3d=void 0;this.chart=a}a.prototype.get3dFrame=function(){var a=this.chart,g=a.options.chart.options3d,e=g.frame,c=a.plotLeft,l=a.plotLeft+a.plotWidth,h=a.plotTop,f=a.plotTop+a.plotHeight,p=g.depth,d=function(g){g=v(g,a);return.5<g?1:-.5>g?-1:0},t=d([{x:c,y:f,z:p},{x:l,y:f,z:p},{x:l,y:f,z:0},{x:c,y:f,z:0}]),n=d([{x:c,y:h,z:0},{x:l,y:h,z:0},{x:l,y:h,z:p},{x:c,y:h,z:p}]),k=d([{x:c,y:h,z:0},{x:c,y:h,z:p},{x:c,
y:f,z:p},{x:c,y:f,z:0}]),m=d([{x:l,y:h,z:p},{x:l,y:h,z:0},{x:l,y:f,z:0},{x:l,y:f,z:p}]),w=d([{x:c,y:f,z:0},{x:l,y:f,z:0},{x:l,y:h,z:0},{x:c,y:h,z:0}]);d=d([{x:c,y:h,z:p},{x:l,y:h,z:p},{x:l,y:f,z:p},{x:c,y:f,z:p}]);var z=!1,H=!1,G=!1,F=!1;[].concat(a.xAxis,a.yAxis,a.zAxis).forEach(function(a){a&&(a.horiz?a.opposite?H=!0:z=!0:a.opposite?F=!0:G=!0)});var u=function(a,g,e){for(var c=["size","color","visible"],l={},h=0;h<c.length;h++)for(var f=c[h],p=0;p<a.length;p++)if("object"===typeof a[p]){var d=a[p][f];
if("undefined"!==typeof d&&null!==d){l[f]=d;break}}a=e;!0===l.visible||!1===l.visible?a=l.visible:"auto"===l.visible&&(a=0<g);return{size:b(l.size,1),color:b(l.color,"none"),frontFacing:0<g,visible:a}};e={axes:{},bottom:u([e.bottom,e.top,e],t,z),top:u([e.top,e.bottom,e],n,H),left:u([e.left,e.right,e.side,e],k,G),right:u([e.right,e.left,e.side,e],m,F),back:u([e.back,e.front,e],d,!0),front:u([e.front,e.back,e],w,!1)};"auto"===g.axisLabelPosition?(m=function(a,g){return a.visible!==g.visible||a.visible&&
g.visible&&a.frontFacing!==g.frontFacing},g=[],m(e.left,e.front)&&g.push({y:(h+f)/2,x:c,z:0,xDir:{x:1,y:0,z:0}}),m(e.left,e.back)&&g.push({y:(h+f)/2,x:c,z:p,xDir:{x:0,y:0,z:-1}}),m(e.right,e.front)&&g.push({y:(h+f)/2,x:l,z:0,xDir:{x:0,y:0,z:1}}),m(e.right,e.back)&&g.push({y:(h+f)/2,x:l,z:p,xDir:{x:-1,y:0,z:0}}),t=[],m(e.bottom,e.front)&&t.push({x:(c+l)/2,y:f,z:0,xDir:{x:1,y:0,z:0}}),m(e.bottom,e.back)&&t.push({x:(c+l)/2,y:f,z:p,xDir:{x:-1,y:0,z:0}}),n=[],m(e.top,e.front)&&n.push({x:(c+l)/2,y:h,z:0,
xDir:{x:1,y:0,z:0}}),m(e.top,e.back)&&n.push({x:(c+l)/2,y:h,z:p,xDir:{x:-1,y:0,z:0}}),k=[],m(e.bottom,e.left)&&k.push({z:(0+p)/2,y:f,x:c,xDir:{x:0,y:0,z:-1}}),m(e.bottom,e.right)&&k.push({z:(0+p)/2,y:f,x:l,xDir:{x:0,y:0,z:1}}),f=[],m(e.top,e.left)&&f.push({z:(0+p)/2,y:h,x:c,xDir:{x:0,y:0,z:-1}}),m(e.top,e.right)&&f.push({z:(0+p)/2,y:h,x:l,xDir:{x:0,y:0,z:1}}),c=function(g,e,b){if(0===g.length)return null;if(1===g.length)return g[0];for(var c=y(g,a,!1),l=0,h=1;h<c.length;h++)b*c[h][e]>b*c[l][e]?l=
h:b*c[h][e]===b*c[l][e]&&c[h].z<c[l].z&&(l=h);return g[l]},e.axes={y:{left:c(g,"x",-1),right:c(g,"x",1)},x:{top:c(n,"y",-1),bottom:c(t,"y",1)},z:{top:c(f,"y",-1),bottom:c(k,"y",1)}}):e.axes={y:{left:{x:c,z:0,xDir:{x:1,y:0,z:0}},right:{x:l,z:0,xDir:{x:0,y:0,z:1}}},x:{top:{y:h,z:0,xDir:{x:1,y:0,z:0}},bottom:{y:f,z:0,xDir:{x:1,y:0,z:0}}},z:{top:{x:G?l:c,y:h,xDir:G?{x:0,y:0,z:1}:{x:0,y:0,z:-1}},bottom:{x:G?l:c,y:f,xDir:G?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return e};a.prototype.getScale=function(a){var g=
this.chart,e=g.plotLeft,b=g.plotWidth+e,c=g.plotTop,l=g.plotHeight+c,h=e+g.plotWidth/2,f=c+g.plotHeight/2,p=Number.MAX_VALUE,d=-Number.MAX_VALUE,t=Number.MAX_VALUE,n=-Number.MAX_VALUE,k=1;var m=[{x:e,y:c,z:0},{x:e,y:c,z:a}];[0,1].forEach(function(a){m.push({x:b,y:m[a].y,z:m[a].z})});[0,1,2,3].forEach(function(a){m.push({x:m[a].x,y:l,z:m[a].z})});m=y(m,g,!1);m.forEach(function(a){p=Math.min(p,a.x);d=Math.max(d,a.x);t=Math.min(t,a.y);n=Math.max(n,a.y)});e>p&&(k=Math.min(k,1-Math.abs((e+h)/(p+h))%1));
b<d&&(k=Math.min(k,(b-h)/(d-h)));c>t&&(k=0>t?Math.min(k,(c+f)/(-t+c+f)):Math.min(k,1-(c+f)/(t+f)%1));l<n&&(k=Math.min(k,Math.abs((l-f)/(n-f))));return k};return a}();e.Composition=B;e.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}};e.compose=function(b,f){var g=b.prototype;f=f.prototype;g.is3d=function(){return!(!this.options.chart.options3d||
!this.options.chart.options3d.enabled)};g.propsRequireDirtyBox.push("chart.options3d");g.propsRequireUpdateSeries.push("chart.options3d");f.matrixSetter=function(){if(1>this.pos&&(k(this.start)||k(this.end))){var a=this.start||[1,0,0,1,0,0],g=this.end||[1,0,0,1,0,0];var b=[];for(var e=0;6>e;e++)b.push(this.pos*g[e]+(1-this.pos)*a[e])}else b=this.end;this.elem.attr(this.prop,b,null,!0)};n(!0,A,e.defaultOptions);c(b,"init",F);c(b,"addSeries",a);c(b,"afterDrawChartBox",l);c(b,"afterGetContainer",t);
c(b,"afterInit",p);c(b,"afterSetChartSize",d);c(b,"beforeRedraw",z);c(b,"beforeRender",u);m(g,"isInsidePlot",w);m(b,"renderSeries",x);m(b,"setClassName",E)}})(e||(e={}));"";return e});D(d,"Core/Axis/ZAxis.js",[d["Core/Axis/Axis.js"],d["Core/Utilities.js"]],function(d,u){function x(b){return new n(this,b)}function A(){var b=this,f=this.options.zAxis=c(this.options.zAxis||{});this.is3d()&&(this.zAxis=[],f.forEach(function(e,c){e.index=c;e.isX=!0;b.addZAxis(e).setScale()}))}var f=this&&this.__extends||
function(){var b=function(c,e){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var e in a)a.hasOwnProperty(e)&&(b[e]=a[e])};return b(c,e)};return function(c,e){function f(){this.constructor=c}b(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,new f)}}(),y=u.addEvent,v=u.merge,E=u.pick,c=u.splat,k=[],n=function(b){function c(e,c){e=b.call(this,e,c)||this;e.isZAxis=!0;return e}f(c,b);c.compose=function(b){-1===k.indexOf(b)&&
(k.push(b),y(b,"afterGetAxes",A),b=b.prototype,b.addZAxis=x,b.collectionsWithInit.zAxis=[b.addZAxis],b.collectionsWithUpdate.push("zAxis"))};c.prototype.getSeriesExtremes=function(){var b=this,c=this.chart;this.hasVisibleSeries=!1;this.dataMin=this.dataMax=this.ignoreMinPadding=this.ignoreMaxPadding=void 0;this.stacking&&this.stacking.buildStacks();this.series.forEach(function(a){if(a.visible||!c.options.chart.ignoreHiddenSeries)b.hasVisibleSeries=!0,a=a.zData,a.length&&(b.dataMin=Math.min(E(b.dataMin,
a[0]),Math.min.apply(null,a)),b.dataMax=Math.max(E(b.dataMax,a[0]),Math.max.apply(null,a)))})};c.prototype.setAxisSize=function(){var e=this.chart;b.prototype.setAxisSize.call(this);this.width=this.len=e.options.chart.options3d&&e.options.chart.options3d.depth||0;this.right=e.chartWidth-this.width-this.left};c.prototype.setOptions=function(e){e=v({offset:0,lineWidth:0},e);this.isZAxis=!0;b.prototype.setOptions.call(this,e);this.coll="zAxis"};return c}(d);return n});D(d,"Core/Axis/Tick3D.js",[d["Core/Utilities.js"]],
function(d){var u=d.addEvent,x=d.extend,A=d.wrap;return function(){function f(){}f.compose=function(d){u(d,"afterGetLabelPosition",f.onAfterGetLabelPosition);A(d.prototype,"getMarkPath",f.wrapGetMarkPath)};f.onAfterGetLabelPosition=function(f){var d=this.axis.axis3D;d&&x(f.pos,d.fix3dPosition(f.pos))};f.wrapGetMarkPath=function(f){var d=this.axis.axis3D,u=f.apply(this,[].slice.call(arguments,1));if(d){var c=u[0],k=u[1];if("M"===c[0]&&"L"===k[0])return d=[d.fix3dPosition({x:c[1],y:c[2],z:0}),d.fix3dPosition({x:k[1],
y:k[2],z:0})],this.axis.chart.renderer.toLineSegments(d)}return u};return f}()});D(d,"Core/Axis/Axis3D.js",[d["Core/Globals.js"],d["Core/Math3D.js"],d["Core/Axis/Tick.js"],d["Core/Axis/Tick3D.js"],d["Core/Utilities.js"]],function(d,u,x,B,f){var y=d.deg2rad,v=u.perspective,A=u.perspective3D,c=u.shapeArea,k=f.addEvent,n=f.merge,b=f.pick,m=f.wrap,e=function(){function e(a){this.axis=a}e.prototype.fix3dPosition=function(a,e){var f=this.axis,l=f.chart;if("colorAxis"===f.coll||!l.chart3d||!l.is3d())return a;
var d=y*l.options.chart.options3d.alpha,k=y*l.options.chart.options3d.beta,n=b(e&&f.options.title.position3d,f.options.labels.position3d);e=b(e&&f.options.title.skew3d,f.options.labels.skew3d);var m=l.chart3d.frame3d,w=l.plotLeft,u=l.plotWidth+w,z=l.plotTop,x=l.plotHeight+z,h=l=0,r={x:0,y:1,z:0},g=!1;a=f.axis3D.swapZ({x:a.x,y:a.y,z:0});if(f.isZAxis)if(f.opposite){if(null===m.axes.z.top)return{};h=a.y-z;a.x=m.axes.z.top.x;a.y=m.axes.z.top.y;w=m.axes.z.top.xDir;g=!m.top.frontFacing}else{if(null===m.axes.z.bottom)return{};
h=a.y-x;a.x=m.axes.z.bottom.x;a.y=m.axes.z.bottom.y;w=m.axes.z.bottom.xDir;g=!m.bottom.frontFacing}else if(f.horiz)if(f.opposite){if(null===m.axes.x.top)return{};h=a.y-z;a.y=m.axes.x.top.y;a.z=m.axes.x.top.z;w=m.axes.x.top.xDir;g=!m.top.frontFacing}else{if(null===m.axes.x.bottom)return{};h=a.y-x;a.y=m.axes.x.bottom.y;a.z=m.axes.x.bottom.z;w=m.axes.x.bottom.xDir;g=!m.bottom.frontFacing}else if(f.opposite){if(null===m.axes.y.right)return{};l=a.x-u;a.x=m.axes.y.right.x;a.z=m.axes.y.right.z;w=m.axes.y.right.xDir;
w={x:w.z,y:w.y,z:-w.x}}else{if(null===m.axes.y.left)return{};l=a.x-w;a.x=m.axes.y.left.x;a.z=m.axes.y.left.z;w=m.axes.y.left.xDir}"chart"!==n&&("flap"===n?f.horiz?(k=Math.sin(d),d=Math.cos(d),f.opposite&&(k=-k),g&&(k=-k),r={x:w.z*k,y:d,z:-w.x*k}):w={x:Math.cos(k),y:0,z:Math.sin(k)}:"ortho"===n?f.horiz?(r=Math.cos(d),n=Math.sin(k)*r,d=-Math.sin(d),k=-r*Math.cos(k),r={x:w.y*k-w.z*d,y:w.z*n-w.x*k,z:w.x*d-w.y*n},d=1/Math.sqrt(r.x*r.x+r.y*r.y+r.z*r.z),g&&(d=-d),r={x:d*r.x,y:d*r.y,z:d*r.z}):w={x:Math.cos(k),
y:0,z:Math.sin(k)}:f.horiz?r={x:Math.sin(k)*Math.sin(d),y:Math.cos(d),z:-Math.cos(k)*Math.sin(d)}:w={x:Math.cos(k),y:0,z:Math.sin(k)});a.x+=l*w.x+h*r.x;a.y+=l*w.y+h*r.y;a.z+=l*w.z+h*r.z;l=v([a],f.chart)[0];e&&(0>c(v([a,{x:a.x+w.x,y:a.y+w.y,z:a.z+w.z},{x:a.x+r.x,y:a.y+r.y,z:a.z+r.z}],f.chart))&&(w={x:-w.x,y:-w.y,z:-w.z}),a=v([{x:a.x,y:a.y,z:a.z},{x:a.x+w.x,y:a.y+w.y,z:a.z+w.z},{x:a.x+r.x,y:a.y+r.y,z:a.z+r.z}],f.chart),l.matrix=[a[1].x-a[0].x,a[1].y-a[0].y,a[2].x-a[0].x,a[2].y-a[0].y,l.x,l.y],l.matrix[4]-=
l.x*l.matrix[0]+l.y*l.matrix[2],l.matrix[5]-=l.x*l.matrix[1]+l.y*l.matrix[3]);return l};e.prototype.swapZ=function(a,b){var e=this.axis;return e.isZAxis?(b=b?0:e.chart.plotLeft,{x:b+a.z,y:a.y,z:a.x-b}):a};return e}();return function(){function c(){}c.compose=function(a){n(!0,a.defaultOptions,c.defaultOptions);a.keepProps.push("axis3D");k(a,"init",c.onInit);k(a,"afterSetOptions",c.onAfterSetOptions);k(a,"drawCrosshair",c.onDrawCrosshair);a=a.prototype;m(a,"getLinePath",c.wrapGetLinePath);m(a,"getPlotBandPath",
c.wrapGetPlotBandPath);m(a,"getPlotLinePath",c.wrapGetPlotLinePath);m(a,"getSlotWidth",c.wrapGetSlotWidth);m(a,"getTitlePosition",c.wrapGetTitlePosition);B.compose(x)};c.onAfterSetOptions=function(){var a=this.chart,c=this.options;a.is3d&&a.is3d()&&"colorAxis"!==this.coll&&(c.tickWidth=b(c.tickWidth,0),c.gridLineWidth=b(c.gridLineWidth,1))};c.onDrawCrosshair=function(a){this.chart.is3d()&&"colorAxis"!==this.coll&&a.point&&(a.point.crosshairPos=this.isXAxis?a.point.axisXpos:this.len-a.point.axisYpos)};
c.onInit=function(){this.axis3D||(this.axis3D=new e(this))};c.wrapGetLinePath=function(a){return this.chart.is3d()&&"colorAxis"!==this.coll?[]:a.apply(this,[].slice.call(arguments,1))};c.wrapGetPlotBandPath=function(a){if(!this.chart.is3d()||"colorAxis"===this.coll)return a.apply(this,[].slice.call(arguments,1));var b=arguments,c=b[2],e=[];b=this.getPlotLinePath({value:b[1]});c=this.getPlotLinePath({value:c});if(b&&c)for(var f=0;f<b.length;f+=2){var d=b[f],k=b[f+1],m=c[f],n=c[f+1];"M"===d[0]&&"L"===
k[0]&&"M"===m[0]&&"L"===n[0]&&e.push(d,k,n,["L",m[1],m[2]],["Z"])}return e};c.wrapGetPlotLinePath=function(a){var b=this.axis3D,c=this.chart,e=a.apply(this,[].slice.call(arguments,1));if("colorAxis"===this.coll||!c.chart3d||!c.is3d()||null===e)return e;var f=c.options.chart.options3d,d=this.isZAxis?c.plotWidth:f.depth;f=c.chart3d.frame3d;var k=e[0],m=e[1];e=[];"M"===k[0]&&"L"===m[0]&&(b=[b.swapZ({x:k[1],y:k[2],z:0}),b.swapZ({x:k[1],y:k[2],z:d}),b.swapZ({x:m[1],y:m[2],z:0}),b.swapZ({x:m[1],y:m[2],
z:d})],this.horiz?(this.isZAxis?(f.left.visible&&e.push(b[0],b[2]),f.right.visible&&e.push(b[1],b[3])):(f.front.visible&&e.push(b[0],b[2]),f.back.visible&&e.push(b[1],b[3])),f.top.visible&&e.push(b[0],b[1]),f.bottom.visible&&e.push(b[2],b[3])):(f.front.visible&&e.push(b[0],b[2]),f.back.visible&&e.push(b[1],b[3]),f.left.visible&&e.push(b[0],b[1]),f.right.visible&&e.push(b[2],b[3])),e=v(e,this.chart,!1));return c.renderer.toLineSegments(e)};c.wrapGetSlotWidth=function(a,c){var e=this.chart,f=this.ticks,
d=this.gridGroup;if(this.categories&&e.frameShapes&&e.is3d()&&d&&c&&c.label){d=d.element.childNodes[0].getBBox();var l=e.frameShapes.left.getBBox(),k=e.options.chart.options3d;e={x:e.plotWidth/2,y:e.plotHeight/2,z:k.depth/2,vd:b(k.depth,1)*b(k.viewDistance,0)};k=c.pos;var m=f[k-1],n=f[k+1],v=f=void 0;0!==k&&m&&m.label&&m.label.xy&&(f=A({x:m.label.xy.x,y:m.label.xy.y,z:null},e,e.vd));n&&n.label&&n.label.xy&&(v=A({x:n.label.xy.x,y:n.label.xy.y,z:null},e,e.vd));k={x:c.label.xy.x,y:c.label.xy.y,z:null};
k=A(k,e,e.vd);return Math.abs(f?k.x-f.x:v?v.x-k.x:d.x-l.x)}return a.apply(this,[].slice.call(arguments,1))};c.wrapGetTitlePosition=function(a){var b=a.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(b,!0):b};c.defaultOptions={labels:{position3d:"offset",skew3d:!1},title:{position3d:null,skew3d:null}};return c}()});D(d,"Core/Series/Series3D.js",[d["Core/Math3D.js"],d["Core/Series/Series.js"],d["Core/Utilities.js"]],function(d,u,x){var A=this&&this.__extends||function(){var c=
function(f,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,e){b.__proto__=e}||function(b,e){for(var c in e)e.hasOwnProperty(c)&&(b[c]=e[c])};return c(f,b)};return function(f,b){function d(){this.constructor=f}c(f,b);f.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),f=d.perspective;d=x.addEvent;var y=x.extend,v=x.merge,E=x.pick,c=x.isNumber;x=function(d){function k(){return null!==d&&d.apply(this,arguments)||this}A(k,d);k.prototype.translate=function(){d.prototype.translate.apply(this,
arguments);this.chart.is3d()&&this.translate3dPoints()};k.prototype.translate3dPoints=function(){var b=this.options,d=this.chart,e=E(this.zAxis,d.options.zAxis[0]),k=[],a,l=[];this.zPadding=(b.stacking?c(b.stack)?b.stack:0:this.index||0)*(b.depth||0+(b.groupZPadding||1));for(a=0;a<this.data.length;a++){b=this.data[a];if(e&&e.translate){var n=e.logarithmic&&e.val2lin?e.val2lin(b.z):b.z;b.plotZ=e.translate(n);b.isInside=b.isInside?n>=e.min&&n<=e.max:!1}else b.plotZ=this.zPadding;b.axisXpos=b.plotX;
b.axisYpos=b.plotY;b.axisZpos=b.plotZ;k.push({x:b.plotX,y:b.plotY,z:b.plotZ});l.push(b.plotX||0)}this.rawPointsX=l;d=f(k,d,!0);for(a=0;a<this.data.length;a++)b=this.data[a],e=d[a],b.plotX=e.x,b.plotY=e.y,b.plotZ=e.z};k.defaultOptions=v(u.defaultOptions);return k}(u);d(u,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()});y(u.prototype,{translate3dPoints:x.prototype.translate3dPoints});return x});D(d,"Series/Area3D/Area3DSeries.js",[d["Core/Math3D.js"],d["Core/Series/SeriesRegistry.js"],
d["Core/Utilities.js"]],function(d,u,x){function A(c){var d=c.apply(this,[].slice.call(arguments,1));if(!this.chart.is3d())return d;var n=y.getGraphPath,b=this.options,m=Math.round(this.yAxis.getThreshold(b.threshold)),e=[];if(this.rawPointsX)for(var v=0;v<this.points.length;v++)e.push({x:this.rawPointsX[v],y:b.stacking?this.points[v].yBottom:m,z:this.zPadding});b=this.chart.options.chart.options3d;e=f(e,this.chart,!0).map(function(a){return{plotX:a.x,plotY:a.y,plotZ:a.z}});this.group&&b&&b.depth&&
b.beta&&(this.markerGroup&&(this.markerGroup.add(this.group),this.markerGroup.attr({translateX:0,translateY:0})),this.group.attr({zIndex:Math.max(1,270<b.beta||90>b.beta?b.depth-Math.round(this.zPadding||0):Math.round(this.zPadding||0))}));e.reversed=!0;n=n.call(this,e,!0,!0);n[0]&&"M"===n[0][0]&&(n[0]=["L",n[0][1],n[0][2]]);this.areaPath&&(n=this.areaPath.splice(0,this.areaPath.length/2).concat(n),n.xMap=this.areaPath.xMap,this.areaPath=n);return d}var f=d.perspective,y=u.seriesTypes.line.prototype,
v=x.wrap,E=[];return{compose:function(c){-1===E.indexOf(c)&&(E.push(c),v(c.prototype,"getGraphPath",A))}}});D(d,"Series/Column3D/Column3DComposition.js",[d["Series/Column/ColumnSeries.js"],d["Core/Globals.js"],d["Core/Series/Series.js"],d["Core/Math3D.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Axis/Stacking/StackItem.js"],d["Core/Utilities.js"]],function(d,u,x,B,f,y,v){function A(a,b){var c=a.series,e={totalStacks:0},f,d=1;c.forEach(function(a){f=z(a.options.stack,b?0:c.length-1-a.index);e[f]?
e[f].series.push(a):(e[f]={series:[a],position:d},d++)});e.totalStacks=d+1;return e}function c(a){var b=a.apply(this,[].slice.call(arguments,1));this.chart.is3d&&this.chart.is3d()&&(b.stroke=this.options.edgeColor||b.fill,b["stroke-width"]=z(this.options.edgeWidth,1));return b}function k(a,b,c){var e=this.chart.is3d&&this.chart.is3d();e&&(this.options.inactiveOtherPoints=!0);a.call(this,b,c);e&&(this.options.inactiveOtherPoints=!1)}function n(a){for(var b=[],e=1;e<arguments.length;e++)b[e-1]=arguments[e];
return this.series.chart.is3d()?this.graphic&&"g"!==this.graphic.element.nodeName:a.apply(this,b)}var b=d.prototype,m=u.svg,e=B.perspective;u=v.addEvent;var z=v.pick;v=v.wrap;v(b,"translate",function(a){a.apply(this,[].slice.call(arguments,1));this.chart.is3d()&&this.translate3dShapes()});v(x.prototype,"justifyDataLabel",function(a){return arguments[2].outside3dPlot?!1:a.apply(this,[].slice.call(arguments,1))});b.translate3dPoints=function(){};b.translate3dShapes=function(){var a=this,b=a.chart,c=
a.options,f=c.depth,d=(c.stacking?c.stack||0:a.index)*(f+(c.groupZPadding||1)),k=a.borderWidth%2?.5:0,m;b.inverted&&!a.yAxis.reversed&&(k*=-1);!1!==c.grouping&&(d=0);d+=c.groupZPadding||1;a.data.forEach(function(c){c.outside3dPlot=null;if(null!==c.y){var l=c.shapeArgs,n=c.tooltipPos,p;[["x","width"],["y","height"]].forEach(function(b){p=l[b[0]]-k;0>p&&(l[b[1]]+=l[b[0]]+k,l[b[0]]=-k,p=0);p+l[b[1]]>a[b[0]+"Axis"].len&&0!==l[b[1]]&&(l[b[1]]=a[b[0]+"Axis"].len-l[b[0]]);if(0!==l[b[1]]&&(l[b[0]]>=a[b[0]+
"Axis"].len||l[b[0]]+l[b[1]]<=k)){for(var e in l)l[e]="y"===e?-9999:0;c.outside3dPlot=!0}});"rect"===c.shapeType&&(c.shapeType="cuboid");l.z=d;l.depth=f;l.insidePlotArea=!0;m={x:l.x+l.width/2,y:l.y,z:d+f/2};b.inverted&&(m.x=l.height,m.y=c.clientX);c.plot3d=e([m],b,!0,!1)[0];n=e([{x:n[0],y:n[1],z:d+f/2}],b,!0,!1)[0];c.tooltipPos=[n.x,n.y]}});a.z=d};v(b,"animate",function(a){if(this.chart.is3d()){var b=arguments[1],c=this.yAxis,e=this,f=this.yAxis.reversed;m&&(b?e.data.forEach(function(a){null!==a.y&&
(a.height=a.shapeArgs.height,a.shapey=a.shapeArgs.y,a.shapeArgs.height=1,f||(a.shapeArgs.y=a.stackY?a.plotY+c.translate(a.stackY):a.plotY+(a.negative?-a.height:a.height)))}):(e.data.forEach(function(a){if(null!==a.y&&(a.shapeArgs.height=a.height,a.shapeArgs.y=a.shapey,a.graphic))a.graphic[a.outside3dPlot?"attr":"animate"](a.shapeArgs,e.options.animation)}),this.drawDataLabels()))}else a.apply(this,[].slice.call(arguments,1))});v(b,"plotGroup",function(a,b,c,e,f,d){"dataLabelsGroup"!==b&&this.chart.is3d()&&
(this[b]&&delete this[b],d&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(d)),this[b]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),this[b].survive=!0,"group"===b||"markerGroup"===b))&&(arguments[3]="visible");return a.apply(this,Array.prototype.slice.call(arguments,1))});v(b,"setVisible",function(a,b){var c=this;c.chart.is3d()&&c.data.forEach(function(a){a.visible=a.options.visible=b="undefined"===typeof b?!z(c.visible,a.visible):
b;c.options.data[c.data.indexOf(a)]=a.options;a.graphic&&a.graphic.attr({visibility:b?"visible":"hidden"})});a.apply(this,Array.prototype.slice.call(arguments,1))});u(d,"afterInit",function(){if(this.chart.is3d()){var a=this.options,b=a.grouping,c=a.stacking,e=this.yAxis.options.reversedStacks,f=0;if("undefined"===typeof b||b){b=A(this.chart,c);f=a.stack||0;for(c=0;c<b[f].series.length&&b[f].series[c]!==this;c++);f=10*(b.totalStacks-b[f].position)+(e?c:-c);this.xAxis.reversed||(f=10*b.totalStacks-
f)}a.depth=a.depth||25;this.z=this.z||0;a.zIndex=f}});v(b,"pointAttribs",c);v(b,"setState",k);v(b.pointClass.prototype,"hasNewShapeType",n);f.seriesTypes.columnRange&&(u=f.seriesTypes.columnrange.prototype,v(u,"pointAttribs",c),v(u,"setState",k),v(u.pointClass.prototype,"hasNewShapeType",n),u.plotGroup=b.plotGroup,u.setVisible=b.setVisible);v(x.prototype,"alignDataLabel",function(a,b,c,f,d){var k=this.chart;f.outside3dPlot=b.outside3dPlot;if(k.is3d()&&this.is("column")){var m=this.options,l=z(f.inside,
!!this.options.stacking),n=k.options.chart.options3d,p=b.pointWidth/2||0;m={x:d.x+p,y:d.y,z:this.z+m.depth/2};k.inverted&&(l&&(d.width=0,m.x+=b.shapeArgs.height/2),90<=n.alpha&&270>=n.alpha&&(m.y+=b.shapeArgs.width));m=e([m],k,!0,!1)[0];d.x=m.x-p;d.y=b.outside3dPlot?-9E9:m.y}a.apply(this,[].slice.call(arguments,1))});v(y.prototype,"getStackBox",function(a,b,c,d,k,m,n,v){var l=a.apply(this,[].slice.call(arguments,1));if(b.is3d()&&c.base){var p=+c.base.split(",")[0],t=b.series[p];p=b.options.chart.options3d;
t&&t instanceof f.seriesTypes.column&&(t={x:l.x+(b.inverted?n:m/2),y:l.y,z:t.options.depth/2},b.inverted&&(l.width=0,90<=p.alpha&&270>=p.alpha&&(t.y+=m)),t=e([t],b,!0,!1)[0],l.x=t.x-m/2,l.y=t.y)}return l});"";return d});D(d,"Series/Pie3D/Pie3DPoint.js",[d["Core/Series/SeriesRegistry.js"]],function(d){var u=this&&this.__extends||function(){var d=function(f,u){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(f,d){f.__proto__=d}||function(f,d){for(var c in d)d.hasOwnProperty(c)&&(f[c]=
d[c])};return d(f,u)};return function(f,u){function v(){this.constructor=f}d(f,u);f.prototype=null===u?Object.create(u):(v.prototype=u.prototype,new v)}}();d=d.seriesTypes.pie.prototype.pointClass;var x=d.prototype.haloPath;return function(d){function f(){var f=null!==d&&d.apply(this,arguments)||this;f.series=void 0;return f}u(f,d);f.prototype.haloPath=function(){return this.series.chart.is3d()?[]:x.apply(this,arguments)};return f}(d)});D(d,"Series/Pie3D/Pie3DSeries.js",[d["Core/Globals.js"],d["Series/Pie3D/Pie3DPoint.js"],
d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,u,x,B){var f=this&&this.__extends||function(){var c=function(f,d){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var e in c)c.hasOwnProperty(e)&&(b[e]=c[e])};return c(f,d)};return function(f,d){function b(){this.constructor=f}c(f,d);f.prototype=null===d?Object.create(d):(b.prototype=d.prototype,new b)}}(),y=d.deg2rad,v=d.svg;d=B.extend;var A=B.pick;x=function(c){function d(){return null!==
c&&c.apply(this,arguments)||this}f(d,c);d.prototype.addPoint=function(){c.prototype.addPoint.apply(this,arguments);this.chart.is3d()&&this.update(this.userOptions,!0)};d.prototype.animate=function(f){if(this.chart.is3d()){var b=this.options.animation;var d=this.center;var e=this.group,k=this.markerGroup;v&&(!0===b&&(b={}),f?(e.oldtranslateX=A(e.oldtranslateX,e.translateX),e.oldtranslateY=A(e.oldtranslateY,e.translateY),d={translateX:d[0],translateY:d[1],scaleX:.001,scaleY:.001},e.attr(d),k&&(k.attrSetters=
e.attrSetters,k.attr(d))):(d={translateX:e.oldtranslateX,translateY:e.oldtranslateY,scaleX:1,scaleY:1},e.animate(d,b),k&&k.animate(d,b)))}else c.prototype.animate.apply(this,arguments)};d.prototype.drawDataLabels=function(){if(this.chart.is3d()){var f=this.chart.options.chart.options3d;this.data.forEach(function(b){var c=b.shapeArgs,e=c.r,d=(c.start+c.end)/2;b=b.labelPosition;var a=b.connectorPosition,k=-e*(1-Math.cos((c.alpha||f.alpha)*y))*Math.sin(d),n=e*(Math.cos((c.beta||f.beta)*y)-1)*Math.cos(d);
[b.natural,a.breakAt,a.touchingSliceAt].forEach(function(a){a.x+=n;a.y+=k})})}c.prototype.drawDataLabels.apply(this,arguments)};d.prototype.pointAttribs=function(f){var b=c.prototype.pointAttribs.apply(this,arguments),d=this.options;this.chart.is3d()&&!this.chart.styledMode&&(b.stroke=d.edgeColor||f.color||this.color,b["stroke-width"]=A(d.edgeWidth,1));return b};d.prototype.translate=function(){c.prototype.translate.apply(this,arguments);if(this.chart.is3d()){var d=this,b=d.options,f=b.depth||0,e=
d.chart.options.chart.options3d,k=e.alpha,a=e.beta,l=b.stacking?(b.stack||0)*f:d._i*f;l+=f/2;!1!==b.grouping&&(l=0);d.data.forEach(function(c){var e=c.shapeArgs;c.shapeType="arc3d";e.z=l;e.depth=.75*f;e.alpha=k;e.beta=a;e.center=d.center;e=(e.end+e.start)/2;c.slicedTranslation={translateX:Math.round(Math.cos(e)*b.slicedOffset*Math.cos(k*y)),translateY:Math.round(Math.sin(e)*b.slicedOffset*Math.cos(k*y))}})}};d.prototype.drawTracker=function(){c.prototype.drawTracker.apply(this,arguments);this.chart.is3d()&&
this.points.forEach(function(c){c.graphic&&["out","inn","side1","side2"].forEach(function(b){c.graphic&&(c.graphic[b].element.point=c)})})};return d}(x.seriesTypes.pie);d(x.prototype,{pointClass:u});"";return x});D(d,"Series/Pie3D/Pie3DComposition.js",[d["Series/Pie3D/Pie3DPoint.js"],d["Series/Pie3D/Pie3DSeries.js"],d["Core/Series/SeriesRegistry.js"]],function(d,u,x){x.seriesTypes.pie.prototype.pointClass.prototype.haloPath=d.prototype.haloPath;x.seriesTypes.pie=u});D(d,"Series/Scatter3D/Scatter3DPoint.js",
[d["Series/Scatter/ScatterSeries.js"],d["Core/Utilities.js"]],function(d,u){var x=this&&this.__extends||function(){var d=function(f,u){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,c){d.__proto__=c}||function(d,c){for(var f in c)c.hasOwnProperty(f)&&(d[f]=c[f])};return d(f,u)};return function(f,u){function v(){this.constructor=f}d(f,u);f.prototype=null===u?Object.create(u):(v.prototype=u.prototype,new v)}}(),A=u.defined;return function(d){function f(){var f=null!==d&&d.apply(this,
arguments)||this;f.options=void 0;f.series=void 0;return f}x(f,d);f.prototype.applyOptions=function(){d.prototype.applyOptions.apply(this,arguments);A(this.z)||(this.z=0);return this};return f}(d.prototype.pointClass)});D(d,"Series/Scatter3D/Scatter3DSeries.js",[d["Core/Math3D.js"],d["Series/Scatter3D/Scatter3DPoint.js"],d["Series/Scatter/ScatterSeries.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,u,x,B,f){var y=this&&this.__extends||function(){var c=function(d,f){c=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var d in c)c.hasOwnProperty(d)&&(b[d]=c[d])};return c(d,f)};return function(d,f){function b(){this.constructor=d}c(d,f);d.prototype=null===f?Object.create(f):(b.prototype=f.prototype,new b)}}(),v=d.pointCameraDistance;d=f.extend;var A=f.merge;f=function(c){function d(){var d=null!==c&&c.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}y(d,c);d.prototype.pointAttribs=function(d){var b=
c.prototype.pointAttribs.apply(this,arguments);this.chart.is3d()&&d&&(b.zIndex=v(d,this.chart));return b};d.defaultOptions=A(x.defaultOptions,{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}});return d}(x);d(f.prototype,{axisTypes:["xAxis","yAxis","zAxis"],directTouch:!0,parallelArrays:["x","y","z"],pointArrayMap:["x","y","z"],pointClass:u});B.registerSeriesType("scatter3d",f);"";return f});D(d,"masters/highcharts-3d.src.js",[d["Core/Globals.js"],d["Core/Renderer/SVG/SVGRenderer3D.js"],
d["Core/Chart/Chart3D.js"],d["Core/Axis/ZAxis.js"],d["Core/Axis/Axis3D.js"],d["Series/Area3D/Area3DSeries.js"]],function(d,u,x,B,f,y){u.compose(d.SVGRenderer);x.compose(d.Chart,d.Fx);B.compose(d.Chart);f.compose(d.Axis);y.compose(d.seriesTypes.area)})});
//# sourceMappingURL=highcharts-3d.js.map