<div class="johannes-section">
    <div class="container">
        <div class="section-content row justify-content-center">
            
            <?php if ( johannes_has_sidebar( 'left' ) ): ?>
		        <div class="col-12 col-lg-4 johannes-order-2">
		            <?php get_sidebar(); ?>
		        </div>
    		<?php endif; ?>

            <div class="col-12 col-lg-<?php echo esc_attr( johannes_get('width') ); ?> single-md-content col-md-special johannes-order-1 <?php echo esc_attr( johannes_single_content_offset() ); ?>">
                <?php if ( johannes_get( 'avatar' ) ) : ?> 
                    <?php get_template_part( 'template-parts/single/content-author' ); ?>
                <?php endif; ?>

                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                    <?php if ( johannes_get( 'layout' ) == 6 ): ?>
                        <?php echo johannes_get_media( johannes_get_post_format(),  '<div class="entry-media mb-0">', '</div>'); ?>
                    <?php endif; ?>

                    <?php if ( in_array( johannes_get( 'layout' ), array( 2, 6, 7 ) ) ): ?>

                        <div class="category-pill section-head-alt single-layout-2">
                            <div class="entry-header">
                                <?php echo johannes_breadcrumbs(); ?>
                                <?php if ( johannes_get( 'category' ) ): ?>
                                    <div class="entry-category">
                                        <?php echo johannes_get_category(); ?>
                                    </div>
                                <?php endif; ?>
                                <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
                                <?php if ( johannes_get( 'meta' ) ): ?>
                                <div class="entry-meta">
                                    <?php echo johannes_get_meta_data( johannes_get( 'meta' ) ); ?>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                    <?php endif; ?>

                    <?php if ( johannes_get( 'layout' ) == 7 ): ?>
                        <?php echo johannes_get_media( johannes_get_post_format(),  '<div class="entry-media mb-0">', '</div>'); ?>
                    <?php endif; ?>

                    <?php if( strpos( johannes_get('share'), 'above' ) !== false ) : ?>
                        <?php get_template_part( 'template-parts/single/share' ); ?>
                    <?php endif; ?>

                    <?php if ( johannes_get( 'headline' ) && has_excerpt() ): ?>
						<div class="entry-summary">
                            <span><?php echo __johannes( 'summary' );?></span>
						    <?php the_excerpt(); ?>
						</div>
					<?php endif; ?>

                    <div class="entry-content entry-single clearfix">
                        <?php the_content(); ?>
                        <?php wp_link_pages( array( 'before' => '<div class="paginated-post-wrapper clearfix">', 'after' => '</div>' ) ); ?>
                    </div>

                </article>

                <?php if ( johannes_get( 'tags' ) && has_tag() ) : ?>
                    <div class="entry-tags clearfix">
                        <?php the_tags( '<span>'.__johannes( 'tagged_as' ).'</span>', ', ', '' ); ?>
                    </div>
                <?php endif; ?>

                <?php if( strpos( johannes_get('share'), 'below' ) !== false  ) : ?>
                    <?php get_template_part( 'template-parts/single/share' ); ?>
                <?php endif; ?>

                <?php if ( johannes_get( 'author' ) ): ?>
            		<?php get_template_part( 'template-parts/single/author' ); ?>
        		<?php endif; ?>
               
		        <?php comments_template(); ?>

            </div>

            <?php if ( johannes_has_sidebar( 'right' ) ): ?>
		        <div class="col-12 col-lg-4 johannes-order-2">
		            <?php get_sidebar(); ?>
		        </div>
    		<?php endif; ?>

        </div>
    </div>
</div>

<?php if ( johannes_get( 'related' ) ): ?>
    <?php get_template_part( 'template-parts/single/related' ); ?>
<?php endif; ?>