<?php if ( johannes_is_woocommerce_active() ) :  ?>
    <div class="johannes-section johannes-front-featured johannes-front-shop">
        <div class="container">
            
            <?php if ( johannes_get( 'shop_display_title' ) ): ?>
                <div class="section-head">
                    <?php if ( johannes_get( 'shop_title_url' ) ) : ?>
                        <h3 class="section-title h2">
                            <a href="<?php echo esc_url( johannes_get( 'shop_title_url' ) ); ?>">
                                <?php echo esc_html( __johannes('front_page_shop_title') ); ?>
                            </a>
                        </h3>
                    <?php else : ?>
                        <h3 class="section-title h2"><?php echo esc_html( __johannes('front_page_shop_title') ); ?></h3>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="section-content row <?php echo esc_attr( johannes_get_fa_class( johannes_get( 'shop_loop' ) ) ); ?> justify-content-md-center">
            
                <?php $front_page_shop = new WP_Query( johannes_get( 'shop_query_args' ) ); ?>
                
                <?php if ( $front_page_shop->have_posts() ) : ?>
                    <?php while ( $front_page_shop->have_posts() ) : $front_page_shop->the_post(); ?>
                        <?php $layout = johannes_get_loop_params( johannes_get( 'shop_loop' ), $front_page_shop->current_post, 'fa' ); ?>
                        <div class="<?php echo esc_attr( $layout['col'] ); ?>">
                            <?php get_template_part( 'template-parts/layouts/' . $layout['style'] ); ?>
                        </div>
                    <?php endwhile; ?>
                <?php endif; ?>

                <?php wp_reset_postdata(); ?>

            </div>
        </div>
    </div>
<?php endif; ?>