<div class="johannes-section johannes-front-classic johannes-front-cpt">
    <div class="container">

    <?php if ( johannes_get( 'cpt_display_title' ) ): ?>
        <div class="section-head">
            <h3 class="section-title h2"><?php echo esc_html( __johannes('front_page_cpt_title') ); ?></h3>
        </div>
    <?php endif; ?>
    
    <div class="section-content row justify-content-center">

            <?php johannes_set( 'sidebar', johannes_get( 'cpt_sidebar' ) ); ?>
            
            <?php if ( johannes_has_sidebar( 'left' ) ): ?>
                <div class="col-12 col-lg-4 johannes-order-3">
                    <?php get_template_part( 'sidebar') ; ?>
                </div>
            <?php endif; ?>

            <div class="col-12 johannes-order-1 <?php echo esc_attr( johannes_get_loop_col_class( johannes_get( 'cpt_loop' ) ) ); ?>">
                <div class="row johannes-items johannes-posts">
                    <?php $front_page_cpt = new WP_Query( johannes_get( 'cpt_query_args' ) ); ?>
                    <?php if ( $front_page_cpt->have_posts() ) : ?>
                        <?php while ( $front_page_cpt->have_posts() ) : $front_page_cpt->the_post(); ?>
                            <?php $layout = johannes_get_loop_params( johannes_get( 'cpt_loop' ), $front_page_cpt->current_post ); ?>
                            <div class="<?php echo esc_attr( $layout['col'] ); ?>">
                                <?php get_template_part( 'template-parts/layouts/' . $layout['style'] ); ?>
                            </div>
                            <?php if( $front_page_cpt->current_post === johannes_get('ads', 'between_position') ) : ?>
                                <?php get_template_part( 'template-parts/ads/between-posts' ); ?>
                            <?php endif; ?>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <?php get_template_part( 'template-parts/archive/empty' ); ?>
                    <?php endif; ?>
                    <?php wp_reset_postdata(); ?>

                </div>
            </div>

            <?php if ( johannes_has_sidebar( 'right' ) ): ?>
                <div class="col-12 col-lg-4 johannes-order-3">
                    <?php get_template_part( 'sidebar') ; ?>
                </div>
            <?php endif; ?>

            <?php if ( johannes_get( 'cpt_display_button' ) ): ?>
                <div class="col-12 text-center johannes-order-2 johannes-pagination">
                    <a class="johannes-button johannes-button-primary johannes-button-large" href="<?php echo esc_url( johannes_get('cpt_button_url') ); ?>">
                        <?php echo esc_html( __johannes('front_page_cpt_view_all_button_text') ); ?>
                    </a>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div>