<?php
namespace ElementorPro\Modules\Forms\Fields;

use ElementorPro\Modules\Forms\Classes;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Tel extends Field_Base {

	public function get_type() {
		return 'tel';
	}

	public function get_name() {
		return __( 'Tel', 'elementor-pro' );
	}

	public function render( $item, $item_index, $form ) {
		$form->add_render_attribute( 'input' . $item_index, 'class', 'elementor-field-textual' );
		$form->add_render_attribute( 'input' . $item_index, 'pattern', '[0-9()#&+*-=.]+' );
		$form->add_render_attribute( 'input' . $item_index, 'title', __( 'Only numbers and phone characters (#, -, *, etc) are accepted.', 'elementor-pro' ) );
		echo '<input size="1" ' . $form->get_render_attribute_string( 'input' . $item_index ) . '>';
	}

	public function validation( $field, Classes\Form_Record $record, Classes\Ajax_Handler $ajax_handler ) {
		if ( empty( $field['value'] ) ) {
			return;
		}
		if ( preg_match( '/^[0-9()#&+*-=.]+$/', $field['value'] ) !== 1 ) {
			$ajax_handler->add_error( $field['id'], __( 'Only numbers and phone characters (#, -, *, etc) are accepted.', 'elementor-pro' ) );
		}
	}
}
add_action( 'elementor_pro/forms/validation/tel', function( $field, $record, $ajax_handler ) {
	//remove native validation
	/**
	 * @var \ElementorPro\Modules\Forms\Module $forms_module
	 */
	$forms_module = \ElementorPro\Plugin::instance()->modules_manager->get_modules( 'forms' );
	remove_action( 'elementor_pro/forms/validation/tel', [ $forms_module->field_types['tel'], 'validation' ] );

	// run your own validation, ex:
	if ( empty( $field['value'] ) ) {
		return;
	}
	// Match this format XXX-XXX-XXXX, 123-456-7890
	if ( preg_match( '/[0-9]{3}(-?)[0-9]{3}(-?)[0-9]{4}/', $field['value'] ) !== 1 ) {
		$ajax_handler->add_error( $field['id'], 'Please make sure the phone number is in XXX-XXX-XXXX format, eg: 123-456-7890' );
	}
}, 9, 3 );

add_action( 'elementor_pro/forms/render_field/tel', function( $item, $item_index, $form ) {
	//remove native render
	/**
	 * @var \ElementorPro\Modules\Forms\Module $forms_module
	 */
	$forms_module = \ElementorPro\Plugin::instance()->modules_manager->get_modules( 'forms' );
	remove_action( 'elementor_pro/forms/render_field/tel', [$forms_module->field_types['tel'] , 'field_render' ], 10, 3 );

	// add your custom render ex:
	$form->add_render_attribute( 'input' . $item_index, 'class', 'elementor-field-textual' );
	$form->add_render_attribute( 'input' . $item_index, 'pattern', '[0-9]{3}(-?)[0-9]{3}(-?)[0-9]{4}' );
	$form->add_render_attribute( 'input' . $item_index, 'title', __( 'Number should be in this format xxx-xxx-xxxx.', 'plugin-name' ) );
	echo '<input size="1" ' . $form->get_render_attribute_string( 'input' . $item_index ) . '>';
}, 9, 3 );
